<?php
// Konfigurācija
$upload_dir = 'uploads/';
$allowed_types = ['hvi'];
$max_file_size = 5 * 1024 * 1024; // 5MB
$show_upload_form = true; // kontrolējam, vai rādīt augšupielādes formu

// Funkcija HVI faila apstrādei
function process_hvi_file($file_path) {
    $data = file_get_contents($file_path);
    $data = str_replace("\0", "", $data);
    
    preg_match_all('/:D;;(\d+);(\d{8}:\d{6})\s+(.*?)(?=\s*:D;;|\s*:ENDTABLE|$)/s', $data, $matches, PREG_SET_ORDER);
    
    $entries = [];
    foreach ($matches as $match) {
        $entry_number = $match[1];
        $timestamp = $match[2];
        $message = trim($match[3]);

        $date = substr($timestamp, 0, 4) . '-' . substr($timestamp, 4, 2) . '-' . substr($timestamp, 6, 2);
        $time = substr($timestamp, 9, 2) . ':' . substr($timestamp, 11, 2) . ':' . substr($timestamp, 13, 2);
        
        $parts = preg_split('/\s+/', $message, 3);
        $code = $parts[0] ?? '';
        $error = $parts[1] ?? '';
        $details = $parts[2] ?? '';
        
        $entries[] = [
            'Nr' => $entry_number,
            'Datums' => $date,
            'Laiks' => $time,
            'Kods' => htmlspecialchars($code),
            'Kļūda' => htmlspecialchars($error),
            'Detalizācija' => htmlspecialchars($details),
            'FullMessage' => htmlspecialchars($message)
        ];
    }
    
    return $entries;
}

// CSV ģenerēšana
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['csv_download']) && isset($_POST['csv_file'])) {
    $file_path = $_POST['csv_file'];
    
    if (file_exists($file_path)) {
        $entries = process_hvi_file($file_path);
        
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="hvi_dati.csv"');
        
        $output = fopen('php://output', 'w');
        fputcsv($output, ['Nr.', 'Datums', 'Laiks', 'Kods', 'Kļūda/Statuss', 'Detalizācija', 'Pilns ieraksts']);
        
        foreach ($entries as $entry) {
            fputcsv($output, [
                $entry['Nr'],
                $entry['Datums'],
                $entry['Laiks'],
                $entry['Kods'],
                $entry['Kļūda'],
                $entry['Detalizācija'],
                $entry['FullMessage']
            ]);
        }
        
        fclose($output);
        exit;
    } else {
        die("<p style='color: red;'>CSV eksportam nepieciešamais fails netika atrasts.</p>");
    }
}

// Galvenā apstrāde
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['hvi_file'])) {
    $file_name = $_FILES['hvi_file']['name'];
    $file_tmp = $_FILES['hvi_file']['tmp_name'];
    $file_size = $_FILES['hvi_file']['size'];
    $file_error = $_FILES['hvi_file']['error'];
    
    $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
    
    if ($file_error !== UPLOAD_ERR_OK) {
        $error = "Augšupielādes kļūda: ";
        switch ($file_error) {
            case UPLOAD_ERR_INI_SIZE: $error .= "Fails ir pārāk liels"; break;
            case UPLOAD_ERR_FORM_SIZE: $error .= "Fails pārsniedz MAX_FILE_SIZE"; break;
            case UPLOAD_ERR_PARTIAL: $error .= "Fails tika augšupielādēts tikai daļēji"; break;
            case UPLOAD_ERR_NO_FILE: $error .= "Nav izvēlēts fails"; break;
            default: $error .= "Nezināma kļūda";
        }
        die("<p style='color: red;'>$error</p>");
    }
    
    if (!in_array($file_ext, $allowed_types)) {
        die("<p style='color: red;'>Atļauts tikai .hvi failu formāts!</p>");
    }
    
    if ($file_size > $max_file_size) {
        die("<p style='color: red;'>Fails pārāk liels (maksimālais izmērs: 5MB)</p>");
    }
    
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }
    
    $target_file = $upload_dir . basename($file_name);
    
    if (move_uploaded_file($file_tmp, $target_file)) {
        $hvi_data = process_hvi_file($target_file);
        
        $show_upload_form = false; // paslēpt formu

        echo "<h2>HVI faila saturs: $file_name</h2>";
        
        if (empty($hvi_data)) {
            echo "<p>Nav atrasts neviens ieraksts HVI failā.</p>";
        } else {
            echo '<div style="overflow-x: auto; max-height: 600px;">';
            echo '<table border="1" cellpadding="5" style="border-collapse: collapse; width: 100%;">';
            echo '<thead><tr>
                    <th>Nr.</th>
                    <th>Datums</th>
                    <th>Laiks</th>
                    <th>Kods</th>
                    <th>Kļūda/Statuss</th>
                    <th>Detalizācija</th>
                    <th>Pilns ieraksts</th>
                  </tr></thead>';
            echo '<tbody>';
            
            foreach ($hvi_data as $entry) {
                echo '<tr>';
                echo '<td>' . $entry['Nr'] . '</td>';
                echo '<td>' . $entry['Datums'] . '</td>';
                echo '<td>' . $entry['Laiks'] . '</td>';
                echo '<td>' . $entry['Kods'] . '</td>';
                echo '<td>' . $entry['Kļūda'] . '</td>';
                echo '<td>' . $entry['Detalizācija'] . '</td>';
                echo '<td>' . $entry['FullMessage'] . '</td>';
                echo '</tr>';
            }
            
            echo '</tbody></table></div>';

            // CSV lejupielādes poga
            echo '<form method="post" action="" style="margin-top: 20px;">
                    <input type="hidden" name="csv_download" value="1">
                    <input type="hidden" name="csv_file" value="' . htmlspecialchars($target_file) . '">
                    <button type="submit" class="submit-btn">Lejupielādēt kā CSV</button>
                  </form>';

            // Poga atgriezties
            echo '<button onclick="window.location.href=window.location.pathname" style="margin-top: 20px; padding: 10px 15px; background: #3498db; color: white; border: none; border-radius: 3px; cursor: pointer;">Atpakaļ</button>';
        }
    } else {
        echo "<p style='color: red;'>Kļūda augšupielādējot failu.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>HVI failu augšupielāde</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            color: #333;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        h1 {
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
        }
        .upload-form {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 30px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        table {
            font-size: 14px;
        }
        th {
            background-color: #3498db;
            color: white;
            position: sticky;
            top: 0;
        }
        td {
            vertical-align: top;
            padding: 8px;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        tr:hover {
            background-color: #e6f7ff;
        }
        .file-input {
            margin: 10px 0;
        }
        .submit-btn {
            background: #3498db;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 3px;
            cursor: pointer;
            font-size: 16px;
        }
        .submit-btn:hover {
            background: #2980b9;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>HVI failu augšupielāde</h1>

        <?php if ($show_upload_form): ?>
        <div class="upload-form">
            <form method="post" enctype="multipart/form-data">
                <div class="file-input">
                    <label for="hvi_file"><b>Izvēlieties HVI failu:</b></label><br>
                    <input type="file" name="hvi_file" id="hvi_file" accept=".hvi" required>
                </div>
                <button type="submit" class="submit-btn">Augšupielādēt un apstrādāt</button>
            </form>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
